<?php

// Make sure SimplePie is included. You may need to change this to match the location of simplepie.inc.
include ('/home/fiva/www/rssparse/simplepie/simplepie.inc');

$feed_array = array(
    'index'   => 'http://blog.livedoor.jp/fivadanceschool/index.rdf',
    'news'    => 'http://blog.livedoor.jp/fivadanceschool/archives/cat_50037767.xml',
    'event'   => 'http://blog.livedoor.jp/fivadanceschool/archives/cat_50037766.xml',
    'release' => 'http://blog.livedoor.jp/fivadanceschool/archives/cat_50037763.xml',
);
$feed_url = (array_key_exists($_GET['feed'], $feed_array)) ? $feed_array[$_GET['feed']] : $feed_array['index'];
$num = is_numeric($_GET['num']) ? $_GET['num'] : 20;

// We'll process this feed with all of the default options.
$feed = new SimplePie();
$feed->set_input_encoding("UTF-8");
$feed->set_output_encoding("Shift-JIS");
$feed->set_feed_url($feed_url);
$feed->set_cache_location($_SERVER['DOCUMENT_ROOT'].'/rssparse/cache');
$feed->init();

// This makes sure that the content is sent to the browser as text/html and the UTF-8 character set (since we didn't change it).
$feed->handle_content_type();

/*
 * Here, we'll loop through all of the items in the feed, and $item represents the current item in the loop.
 */
$items_array = $feed->get_items();
if (count($items_array) > 0) {
    for ($i=0; $i < $num && $i < count($items_array); $i++) {
        $item = $items_array[$i];
        echo ($item->get_date('y/m/d').'<br>');
        echo ('&nbsp;<a href="'.$item->get_permalink().'">'.$entry_title = mb_convert_kana($item->get_title(), "k", "sjis-win").'</a><br>');
        echo ('<br>');
    }

} else {
    echo ('<dt class="index_event_cassete">݂͂܂B</dt>');
    echo ('<dd>&nbsp;</dd>');
}
?>
