package FCC::Class::HTTP::MobileAgent;
$VERSION = 1.00;
use strict;
use warnings;

#----------------------------------------------------------
#モバイルかどうかを判定するためのIPアドレス帯域の定義
# 2008/10/10現在
#----------------------------------------------------------
my %mobi_subnets = (
	# NTT DoCoMo
	# http://www.nttdocomo.co.jp/service/imode/make/content/ip/#ip
	DoCoMo => [
		#WEBアクセス時 （iモードブラウザ）
		'210.153.84.0/24',
		'210.136.161.0/24',
		'210.153.86.0/24',
		'124.146.174.0/24',
		'124.146.175.0/24',
		#WEBアクセス時（フルブラウザ）
		'210.153.87.0/24'
	],
	# KDDI au
	# http://www.au.kddi.com/ezfactory/tec/spec/ezsava_ip.html
	KDDI => [
		'210.169.40.0/24',
		'210.196.3.192/26',
		'210.196.5.192/26',
		'210.230.128.0/24',
		'210.230.141.192/26',
		'210.234.105.32/29',
		'210.234.108.64/26',
		'210.251.1.192/26',
		'210.251.2.0/27',
		'211.5.1.0/24',
		'211.5.2.128/25',
		'211.5.7.0/24',
		'218.222.1.0/24',
		'61.117.0.0/24',
		'61.117.1.0/24',
		'61.117.2.0/26',
		'61.202.3.0/24',
		'219.108.158.0/26',
		'219.125.148.0/24',
		'222.5.63.0/24',
		'222.7.56.0/24',
		'222.5.62.128/25',
		'222.7.57.0/24',
		'59.135.38.128/25',
		'219.108.157.0/25',
		'219.125.151.128/25',
		'219.125.145.0/25',
		'121.111.231.0/25',
		'121.111.231.160/27',
		'121.111.227.0/25',
		'121.111.227.160/27'
	],
	# Softbank
	# http://creation.mb.softbank.jp/web/web_ip.html
	Softbank => [
		#Yahoo!ケータイにて利用するIPアドレス帯域  
		'123.108.236.0/24',
		'123.108.237.0/27',
		'202.179.204.0/24',
		'202.253.96.224/27',
		'210.146.7.192/26',
		'210.146.60.192/26',
		'210.151.9.128/26',
		'210.169.130.112/28',
		'210.175.1.128/25',
		'210.228.189.0/24',
		'211.8.159.128/25',
		#PCサイトブラウザにて利用するIPアドレス帯域
		'123.108.237.240/28',
		'202.253.96.0/28'
	],
	# WILLCOM
	# http://www.willcom-inc.com/ja/service/contents_service/club_air_edge/for_phone/ip/
	WILLCOM => [
		'61.198.142.0/24',
		'219.108.14.0/24',
		'61.198.161.0/24',
		'219.108.0.0/24',
		'61.198.249.0/24',
		'219.108.1.0/24',
		'61.198.250.0/24',
		'219.108.2.0/24',
		'61.198.253.0/24',
		'219.108.3.0/24',
		'61.198.254.0/24',
		'219.108.4.0/24',
		'61.198.255.0/24',
		'219.108.5.0/24',
		'61.204.3.0/25',
		'219.108.6.0/24',
		'61.204.4.0/24',
		'221.119.0.0/24',
		'61.204.6.0/25',
		'221.119.1.0/24',
		'125.28.4.0/24',
		'221.119.2.0/24',
		'125.28.5.0/24',
		'221.119.3.0/24',
		'125.28.6.0/24',
		'221.119.4.0/24',
		'125.28.7.0/24',
		'221.119.5.0/24',
		'125.28.8.0/24',
		'221.119.6.0/24',
		'211.18.235.0/24',
		'221.119.7.0/24',
		'211.18.238.0/24',
		'221.119.8.0/24',
		'211.18.239.0/24',
		'221.119.9.0/24',
		'125.28.11.0/24',
		'125.28.13.0/24',
		'125.28.12.0/24',
		'125.28.14.0/24',
		'125.28.2.0/24',
		'125.28.3.0/24',
		'211.18.232.0/24',
		'211.18.233.0/24',
		'211.18.236.0/24',
		'211.18.237.0/24',
		'125.28.0.0/24',
		'125.28.1.0/24',
		'61.204.0.0/24',
		'210.168.246.0/24',
		'210.168.247.0/24',
		'219.108.7.0/24',
		'61.204.2.0/24',
		'61.204.5.0/24',
		'61.198.129.0/24',
		'61.198.140.0/24',
		'61.198.141.0/24',
		'125.28.15.0/24',
		'61.198.165.0/24',
		'61.198.166.0/24',
		'61.198.168.0/24',
		'61.198.169.0/24',
		'61.198.170.0/24',
		'61.198.248.0/24',
		'125.28.16.0/24',
		'125.28.17.0/24',
		'211.18.234.0/24',
		'219.108.8.0/24',
		'219.108.9.0/24',
		'219.108.10.0/24',
		'61.198.138.100/32',
		'61.198.138.101/32',
		'61.198.138.102/32',
		'61.198.139.160/28',
		'61.198.139.128/27',
		'61.198.138.103/32',
		'61.198.139.0/29',
		'219.108.15.0/24',
		'61.198.130.0/24',
		'61.198.163.0/24',
		'61.204.6.128/25',
		'61.204.7.0/25',
		'61.204.92.0/24',
		'61.204.93.0/24',
		'61.204.94.0/24',
		'61.204.95.0/24',
		'61.198.128.0/24',
		'61.198.131.0/24',
		'61.198.143.0/24',
		'61.198.172.0/24',
		'61.198.173.0/24',
		'61.198.252.0/24',
		'61.204.3.128/25',
		'211.126.192.128/25',
		'219.108.11.0/24',
		'219.108.12.0/24',
		'219.108.13.0/24',
		'61.198.132.0/24',
		'61.198.133.0/24',
		'61.198.134.0/24',
		'61.198.135.0/24',
		'61.198.136.0/24',
		'61.198.137.0/24',
		'61.198.160.0/24',
		'61.198.162.0/24',
		'61.198.164.0/24',
		'61.198.171.0/24',
		'61.198.174.0/24',
		'61.198.175.0/24',
		'61.198.251.0/24',
		'210.169.92.0/24',
		'210.169.93.0/24',
		'210.169.94.0/24',
		'210.169.95.0/24',
		'210.169.96.0/24',
		'210.169.97.0/24',
		'210.169.98.0/24',
		'210.169.99.0/24'
	]
);

#---------------------------------------------------------------------

sub new {
	my($caller, %args) = @_;
	my $class = ref($caller) || $caller;
	my $self = {};
	unless($args{user_agent}) {
		$args{user_agent} = $ENV{HTTP_USER_AGENT};
	}
	unless($args{remote_addr}) {
		$args{remote_addr} = $ENV{REMOTE_ADDR};
	}
	$self->{user_agent} = $args{user_agent};
	$self->{remote_addr} = $args{remote_addr};
	$self->{ip_detect_mode} = $args{ip_detect_mode};
	bless $self, $class;
	return $self;
}


sub user_agent {
	my($self) = @_;
	return $self->{user_agent};
}

sub carrier {
	my($self, $ua) = @_;
	if($self->{ip_detect_mode}) {
		return $self->_detect_carrier_by_ip($ua);
	} else {
		return $self->_detect_carrier($ua);
	}
}

sub serial {
	my($self) = @_;
	my $cr = $self->carrier();
	if($cr eq "DoCoMo") {
		if( $ENV{HTTP_X_DCMGUID} && $ENV{HTTP_X_DCMGUID} =~ /^[a-zA-Z0-9]{5,32}$/ ) {
			return $ENV{HTTP_X_DCMGUID};
		}
	} elsif($cr eq "KDDI") {
		if( $ENV{HTTP_X_UP_SUBNO} && $ENV{HTTP_X_UP_SUBNO} =~ /^\d{14}\_[a-zA-Z0-9]{2}\.ezweb\.ne\.jp$/ ) {
			return $ENV{HTTP_X_UP_SUBNO};
		}
	} elsif($cr eq "Softbank") {
		if($ENV{HTTP_USER_AGENT} =~ /\/(SN[a-zA-Z0-9]{11,15})/) {
			return $1;
		} elsif( $ENV{HTTP_X_JPHONE_UID} && $ENV{HTTP_X_JPHONE_UID} =~ /^[a-zA-Z0-9]{10,32}$/ ) {
			return $ENV{HTTP_X_JPHONE_UID};
		}
	}
	return undef;
}

#---------------------------------------------------------------------

sub _detect_carrier {
	my($self, $ua) = @_;
	unless($ua) {
		$ua = $self->{user_agent};
	}
	if($ua =~ /DoCoMo/) {
		return 'DoCoMo';
	} elsif($ua =~ /KDDI/ || $ua =~ /UP\.\s*Browser/i) {
		return 'KDDI';
	} elsif($ua =~ /(J\-PHONE|Vodafone|Softbank|Semulator)/i) {
		return 'Softbank';
	} elsif($ua =~ /(DIPOCKET|WILLCOM)\;\w+\/([\w\d\-]+)/i) {
		return 'WILLCOM';
	} elsif($ua =~ /(KYOCERA|SHARP)\/([AW][\w\d\-]+)/) {
		return 'WILLCOM';
	} elsif($ua =~ /KYOCERAAH\-([\w\d\-]+)/) {
		return 'WILLCOM';
	} elsif($ua =~ /SHARP ([AW][\w\d\-]+)\//) {
		return 'WILLCOM';
	} else {
		return '';
	}
}

sub _detect_carrier_by_ip {
	my($self, $ip) = @_;
	unless($ip) {
		$ip = $self->{remote_addr};
	}
	my $type = '';
	my @parts = split(/\./, $ip);
	my $bitptn;
	for my $decimal (@parts) {
		$bitptn .= unpack("B8", pack("C", $decimal));
	}
	while( my($c, $ref) = each %mobi_subnets ) {
		for my $subnet (@{$ref}) {
			if( $subnet =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)\/(\d+)$/ ) {
				my @parts;
				$parts[1] = $1;
				$parts[2] = $2;
				$parts[3] = $3;
				$parts[4] = $4;
				my $mask = $5;
				my $bits;
				for(my $i=1; $i<=4; $i++) {
					$bits .= unpack("B8", pack("C", $parts[$i]));
				}
				my $maskptn = substr($bits, 0, $mask);
				if($bitptn =~ /^${maskptn}/) {
					$type = $c;
					last;
				}
			}
		}
		if($type) {last;}
	}
	return $type;
}


1;
